/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.org.pircbotx.hooks.events;

import javax.annotation.Nullable;
import lombok.NonNull;
import net.creeperhost.minetogether.repack.org.pircbotx.PircBotX;
import net.creeperhost.minetogether.repack.org.pircbotx.User;
import net.creeperhost.minetogether.repack.org.pircbotx.UserHostmask;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.Event;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.types.GenericUserEvent;

public class NickChangeEvent
extends Event
implements GenericUserEvent {
    protected final String oldNick;
    protected final String newNick;
    protected final UserHostmask userHostmask;
    protected final User user;

    public NickChangeEvent(PircBotX bot, @NonNull String oldNick, @NonNull String newNick, @NonNull UserHostmask userHostmask, User user) {
        super(bot);
        if (oldNick == null) {
            throw new NullPointerException("oldNick is marked non-null but is null");
        }
        if (newNick == null) {
            throw new NullPointerException("newNick is marked non-null but is null");
        }
        if (userHostmask == null) {
            throw new NullPointerException("userHostmask is marked non-null but is null");
        }
        this.oldNick = oldNick;
        this.newNick = newNick;
        this.userHostmask = userHostmask;
        this.user = user;
    }

    @Override
    public void respond(String response) {
        this.getUser().send().message(response);
    }

    public String getOldNick() {
        return this.oldNick;
    }

    public String getNewNick() {
        return this.newNick;
    }

    public String toString() {
        return "NickChangeEvent(oldNick=" + this.getOldNick() + ", newNick=" + this.getNewNick() + ", userHostmask=" + this.getUserHostmask() + ", user=" + this.getUser() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NickChangeEvent)) {
            return false;
        }
        NickChangeEvent other = (NickChangeEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$oldNick = this.getOldNick();
        String other$oldNick = other.getOldNick();
        if (this$oldNick == null ? other$oldNick != null : !this$oldNick.equals(other$oldNick)) {
            return false;
        }
        String this$newNick = this.getNewNick();
        String other$newNick = other.getNewNick();
        if (this$newNick == null ? other$newNick != null : !this$newNick.equals(other$newNick)) {
            return false;
        }
        UserHostmask this$userHostmask = this.getUserHostmask();
        UserHostmask other$userHostmask = other.getUserHostmask();
        if (this$userHostmask == null ? other$userHostmask != null : !((Object)this$userHostmask).equals(other$userHostmask)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        return !(this$user == null ? other$user != null : !((Object)this$user).equals(other$user));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NickChangeEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $oldNick = this.getOldNick();
        result = result * 59 + ($oldNick == null ? 43 : $oldNick.hashCode());
        String $newNick = this.getNewNick();
        result = result * 59 + ($newNick == null ? 43 : $newNick.hashCode());
        UserHostmask $userHostmask = this.getUserHostmask();
        result = result * 59 + ($userHostmask == null ? 43 : ((Object)$userHostmask).hashCode());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        return result;
    }

    @Override
    public UserHostmask getUserHostmask() {
        return this.userHostmask;
    }

    @Override
    @Nullable
    public User getUser() {
        return this.user;
    }
}

